/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core;

import com.mojang.logging.LogUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.ducks.IEClientWorld;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.StableClientTimer;
import qouteall.q_misc_util.Helper;

@OnlyIn(value=Dist.CLIENT)
public class CHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int reportedErrorNum = 0;

    public static PlayerInfo getClientPlayerListEntry() {
        return Minecraft.m_91087_().m_91403_().m_104949_(Minecraft.m_91087_().f_91074_.m_36316_().getId());
    }

    public static Level getClientWorld(ResourceKey<Level> dimension) {
        return ClientWorldLoader.getWorld(dimension);
    }

    @Nullable
    public static List<Portal> getClientGlobalPortal(Level world) {
        if (world instanceof ClientLevel) {
            return ((IEClientWorld)world).getGlobalPortals();
        }
        return null;
    }

    public static Stream<Portal> getClientNearbyPortals(double range) {
        return IPMcHelper.getNearbyPortals((Entity)Minecraft.m_91087_().f_91074_, range);
    }

    public static void checkGlError() {
        if (!IPGlobal.doCheckGlError) {
            return;
        }
        if (reportedErrorNum > 100) {
            return;
        }
        CHelper.doCheckGlError();
    }

    public static void doCheckGlError() {
        int errorCode = GL11.glGetError();
        if (errorCode != 0) {
            Helper.err("OpenGL Error" + errorCode);
            new Throwable().printStackTrace();
            ++reportedErrorNum;
        }
    }

    public static void printChat(String str) {
        Helper.log(str);
        CHelper.printChat((Component)Component.m_237113_((String)str));
    }

    public static void printChat(Component text) {
        Minecraft.m_91087_().f_91065_.m_93076_().m_93785_(text);
    }

    public static void openLinkConfirmScreen(Screen parent, String link) {
        Minecraft client = Minecraft.m_91087_();
        client.m_91152_((Screen)new ConfirmLinkScreen(result -> {
            if (result) {
                try {
                    Util.m_137581_().m_137648_(new URI(link));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            client.m_91152_(parent);
        }, link, true));
    }

    public static Vec3 getCurrentCameraPos() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
    }

    public static Iterable<Entity> getWorldEntityList(Level world) {
        if (!(world instanceof ClientLevel)) {
            return (Iterable)((Object)Collections.emptyList().iterator());
        }
        ClientLevel clientWorld = (ClientLevel)world;
        return clientWorld.m_104735_();
    }

    public static double getSmoothCycles(long unitTicks) {
        return (double)((float)(StableClientTimer.getStableTickTime() % unitTicks) + StableClientTimer.getStablePartialTicks()) / (double)unitTicks;
    }

    public static void disableDepthClamp() {
        if (IPGlobal.enableClippingMechanism) {
            GL11.glDisable((int)34383);
        }
    }

    public static void enableDepthClamp() {
        if (IPGlobal.enableClippingMechanism) {
            GL11.glEnable((int)34383);
        }
    }

    @Nullable
    public static ResourceLocation getDimensionIconPath(ResourceKey<Level> dimension) {
        ResourceLocation dimensionId = dimension.m_135782_();
        ResourceLocation dimIconPath = new ResourceLocation(dimensionId.m_135827_(), "textures/dimension/" + dimensionId.m_135815_() + ".png");
        Optional resource = Minecraft.m_91087_().m_91098_().m_213713_(dimIconPath);
        if (resource.isEmpty()) {
            LOGGER.info("Cannot load texture {}", (Object)dimIconPath);
            ResourceLocation modIconLocation = O_O.getModIconLocation(dimensionId.m_135827_());
            if (modIconLocation == null) {
                return null;
            }
            ResourceLocation modIconPath = new ResourceLocation(modIconLocation.m_135827_(), modIconLocation.m_135815_());
            Optional modIconResource = Minecraft.m_91087_().m_91098_().m_213713_(modIconPath);
            if (modIconResource.isEmpty()) {
                LOGGER.info("Cannot load texture {}", (Object)modIconPath);
                return null;
            }
            return modIconPath;
        }
        return dimIconPath;
    }
}

